/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the FOO module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/


function Component()
{
    // constructor
//     component.loaded.connect(this, Component.prototype.loaded);
    if (installer.isInstaller()) {
        console.log("Adding Database config page");
        //installer.addWizardPage(component, "Page", QInstaller.InstallationFinished)
        if (installer.addWizardPage(component, "Page", QInstaller.InstallationFinished)) {
            var widget = gui.pageWidgetByObjectName("DynamicPage");
            if (widget != null) {
                widget.pushButton.clicked.connect(this, Component.prototype.testDbConfigCallback);
                //widget.targetDirectory.textChanged.connect(this, Component.prototype.targetChanged);

                //widget.windowTitle = "Installation Folder";
                //widget.targetDirectory.text = Dir.toNativeSparator(installer.value("TargetDir"));
            }
        }
    }
}

Component.prototype.retranslateUi = function()
{
    //component.languageChanged();
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    if(systemInfo.productType === "windows"){
		component.addOperation("CreateShortcut", "@TargetDir@/Apteka.exe", "@StartMenuDir@/ML-TIM Apteka.lnk", "workingDirectory=@TargetDir@", "iconPath=@TargetDir@/Apteka.exe");
		component.addOperation("CreateShortcut", "@TargetDir@/Apteka.exe", "@HomeDir@/Desktop/ML-TIM Apteka.lnk", "workingDirectory=@TargetDir@", "iconPath=@TargetDir@/Apteka.exe");
    } 
    component.addOperation("Mkdir", "@HomeDir@/.Apteka/");
	component.addOperation("Mkdir", "@TargetDir@/dbUpdate/");
    component.addOperation("CopyDirectory", "@TargetDir@/dbUpdate/", "@HomeDir@/.Apteka/");
}

Component.prototype.testDbConfigCallback = function () {
    //tuka najverojatno ne mozhe da se koristi component
    var page = gui.pageWidgetByObjectName("DynamicPage");
    page.lbMessage.text = "";
    var targetDirectory = installer.value("TargetDir");
    console.log("targetDirectory: " + targetDirectory);
    var apExec;
    //Opciite i vrednostite se davaat oddeleni so zapirka i bez nikakvi spejsovi. Sam si stava spejsovi na sekoja zapirka.
    var args = ["-C", page.leServer.text, "-u", page.leUser.text, "-p", page.lePass.text, "-d", page.leDatabase.text];
	var res;
    if (systemInfo.productType === "windows") {
        apExec = targetDirectory + "\\Apteka.exe";
        res = installer.execute(apExec, args);
    } else {
        //on linux we have to use bash since Apteka does not work without LD_LIBRARY_PATH and this is only way
        apExec = "/bin/bash";
        args = ["-c", "LD_LIBRARY_PATH=" + targetDirectory + " " + targetDirectory + "/Apteka " + args];
		res = installer.execute(apExec, args);
    }
    console.log("apExec = " + apExec + " args = " + args);
    console.log("res: " + res);
    if (res !== "" && res[1] === 0) {
        gui.clickButton(buttons.NextButton); // automatically click the Next button on success
    } else {
        page.lbMessage.text = "Database connection failed";
    }
}
